require "ISUI/ISVehicleMenu"
require "ISUI/ISCollapsableWindow"

local function onOpenVehicleDoor(playerObj)
	local playerNum = playerObj:getPlayerNum()
	local lootWindow = getPlayerLoot(playerNum)
	if lootWindow and lootWindow.isCollapsed then
		lootWindow.isCollapsed = false
		lootWindow:clearMaxDrawHeight()
		lootWindow.collapseCounter = 0
	end
end

local function firstOpenDoor(playerObj, vehicle, seat)
	ISTimedActionQueue.add(ISPathFindAction:pathToVehicleSeat(playerObj, vehicle, seat))
	local doorPart = vehicle:getPassengerDoor(seat)
	if doorPart and doorPart:getDoor() and doorPart:getInventoryItem() then
		local door = doorPart:getDoor()
		if door:isLocked() then
			ISTimedActionQueue.add(ISUnlockVehicleDoor:new(playerObj, doorPart))
		end
		if not door:isOpen() then
			ISTimedActionQueue.add(ISOpenVehicleDoor:new(playerObj, vehicle, doorPart))
			if not door:isLocked() then
			--	print("true:1")
			--	door:setOpen(true)
				return true
			elseif playerObj:getInventory():haveThisKeyId(vehicle:getKeyId()) then
			--	print("true:2")
			--	door:setLocked(false)
			--	door:setOpen(true)
				return true
			else
			--	print("false:1")
				return false
			end
		else
		--	print("true:3")
			return true
		end
	else
	--	print("true:4")
		return true
	end
end

--Vanilla Functions Modified
function ISVehicleMenu.onEnter(playerObj, vehicle, seat)
	if vehicle:isSeatOccupied(seat) then
		if vehicle:getCharacter(seat) then
			HaloTextHelper.addBadText(playerObj, getText("IGUI_PlayerText_VehicleSomeoneInSeat"));
		else
			if firstOpenDoor(playerObj, vehicle, seat) then
				if not ISVehicleMenu.moveItemsFromSeat(playerObj, vehicle, seat, true, true) then
					HaloTextHelper.addBadText(playerObj, getText("IGUI_PlayerText_VehicleItemInSeat"));
				else
					onOpenVehicleDoor(playerObj)
				end
			end
		end
	else
		if isShiftKeyDown() then
			ISVehicleMenu.processShiftEnter(playerObj, vehicle, seat)
		elseif vehicle:isPassengerUseDoor2(playerObj, seat) then
			ISVehicleMenu.processEnter2(playerObj, vehicle, seat);
		else 
			ISVehicleMenu.processEnter(playerObj, vehicle, seat);
		end
	end
end
